/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.target;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.target.CommonTargetingTasklet;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetActionListener;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public final class TaskletTargetActionListener
implements TargetActionListener {
    private static final String TRACE_MASKT = "XCMTTTAT";
    private static final String TRACE_MASKF = "XCMTTTAF";
    private static final String TRACE_MASKD = "XCMTTTAD";
    public static final int ACTION_REDIRECT = 1;
    public static final int ACTION_SUBTASKLET = 2;
    private LocalizableText name = null;
    private ClassId[] types = null;
    private String taskletName = null;
    private int actionType = 1;
    private Target[] targets = null;

    public TaskletTargetActionListener(String taskletName, LocalizableText name, ClassId[] allowedTypes, int actionType) {
        if (taskletName == null) {
            throw new IllegalArgumentException("null tasklet classname specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("null action name specified");
        }
        if (actionType != 1 && actionType != 2) {
            throw new IllegalArgumentException("Invalid action type [" + actionType + "] specified");
        }
        this.name = name;
        if (allowedTypes != null) {
            this.types = new ClassId[allowedTypes.length];
            System.arraycopy(allowedTypes, 0, this.types, 0, this.types.length);
        }
        this.taskletName = taskletName;
        this.actionType = actionType;
    }

    public LocalizableText getActionName() {
        return this.name;
    }

    public TargetActionListener[] getSubActions() {
        return null;
    }

    public ClassId[] getAllowedTypes() {
        return this.types;
    }

    public void performAction(Target[] targets) throws HException {
        throw new UnsupportedOperationException("performAction is not supported");
    }

    void performAction(Target[] targets, PanelTaskletResponse response, PanelTasklet tasklet) {
        Trace.trace(TRACE_MASKF, "-> TaskletTargetActionListener.performAction");
        this.targets = targets;
        Trace.trace(TRACE_MASKF, "targets are: " + targets);
        for (int i = 0; targets != null && i < targets.length; ++i) {
            Trace.trace(TRACE_MASKF, "targets[" + i + "]=" + targets[i].getObjectId());
        }
        switch (this.actionType) {
            case 1: {
                Trace.trace(TRACE_MASKF, "redirecting to: " + this.taskletName);
                response.redirect(this.taskletName, this);
                break;
            }
            case 2: {
                Trace.trace(TRACE_MASKF, "creating subtasklet of: " + this.taskletName);
                DisplayAreaDescriptorDelegate delegate = new DisplayAreaDescriptorDelegate(this.taskletName, null);
                response.openModalChild(delegate);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid action type [" + this.actionType + "] encountered");
            }
        }
        if (tasklet instanceof CommonTargetingTasklet) {
            ((CommonTargetingTasklet)tasklet).setTaskletTargetActionListener(this);
        }
        Trace.trace(TRACE_MASKF, "<- TaskletTargetActionListener.performAction");
    }

    public int getActionType() {
        return this.actionType;
    }

    Target[] getSelectedTargets() {
        Trace.trace(TRACE_MASKF, "<- TaskletTargetActionListener.getSelectedTargets");
        Trace.trace(TRACE_MASKF, "targets are: " + this.targets);
        for (int i = 0; this.targets != null && i < this.targets.length; ++i) {
            Trace.trace(TRACE_MASKF, "targets[" + i + "]=" + this.targets[i].getObjectId());
        }
        Trace.trace(TRACE_MASKF, "<- TaskletTargetActionListener.getSelectedTargets");
        return this.targets;
    }
}

